#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

TextBox::TextBox(short xLocation, short yLocation, short winWidth, char **stringarray) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = stringarray;
    input  = (char *)calloc((width / 8), sizeof(char));
    *ref = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
    entertype = 0;
}
TextBox::TextBox(short xLocation, short yLocation, short winWidth, bool clearbox, void (*funct)(char *)) {
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    ref = NULL;
    input  = (char *)calloc((width / 8), sizeof(char));
    waitingforinput = false;
    press = funct;
    if(clearbox == true) {
        entertype = 1;
    } else {
        entertype = 2;
    }
}
bool TextBox::StartInput(void) {
    if(!waitingforinput) {
        if(entertype == 0) {
            strclr(input);
            strcpy(input, *ref);
        } else if(entertype == 1) {
            strclr(input);
        }
        clear_keybuf();
        waitingforinput = true;
    }
}
void TextBox::SetInput(char *stringy)
{
    Init_String(input, stringy, 0);
}
bool TextBox::StartInput(char *startstring) {
    if(!waitingforinput) {
        if(entertype == 0) {
            Init_String(input, startstring, 0);
            strcpy(input, *ref);
        } else if(entertype == 1) {
            Init_String(input, startstring, 0);
        }
        clear_keybuf();
        waitingforinput = true;
    }
}
bool TextBox::CancelInput(void) {
    if(waitingforinput) {
        if(entertype == 0 || entertype == 1) {
            strclr(input);
        }
        waitingforinput = false;
    }
}
int TextBox::GetString(char *stringy) {
    if(stringy != NULL) {
        strcpy(stringy, input);
    }
    return strlen(input);
}
void TextBox::SetRefmode(short refset) {
    entertype = refset;
    strclr(input);
}
bool TextBox::Check(short xLocation, short yLocation) {
    bool ret = false;
    if(waitingforinput) {
        ret = true;
        if(strlen(input) < (width / 8) - 1) {
            GetInputFromBuffer(input, strlen(input), 1);
        } else {
            GetInputFromBuffer(input, strlen(input) - 1, 1);
        }
        if((mouse_b & 1) || (mouse_b & 2)) {
            if(entertype == 0) {
                strcpy(*ref, input);
			}
            clear_keybuf();
            waitingforinput = false;
        }
        if(key[KEY_ENTER]) {
            if(entertype == 0) {
                strcpy(*ref, input);
                strclr(input);
            } else if(entertype == 1) {
                press(input);
                strclr(input);
            } else if(entertype == 2) {
                press(input);
            }
            clear_keybuf();
            waitingforinput = false;
        }
    }
    if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, 16)) {
        if(mouse_b & 1) {
            if(!waitingforinput) {
                /*if(entertype == 0) {
                    strclr(input);
                    strcpy(input, *ref);
                } else if(entertype == 1) {
                    strclr(input);
                }*/
                clear_keybuf();
                waitingforinput = true;
                ret = true;
            }
        }
    }     
    if(curflash < 90) {
        curflash ++;
    } else {
        curflash = 0;
    }
    return ret;
}
void TextBox::Draw(BITMAP *output, short xLocation, short yLocation) {
    text_box(output, xPos + xLocation, yPos + yLocation, width, 16, makecol(64,64,64), NULL);
    if(ref != NULL && !waitingforinput) {
        textprintf(output, font, xPos + xLocation + 6, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s", *ref);
        textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%s", *ref);
        textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s", *ref); 
    }
    if(entertype == 2 && !waitingforinput) {
        textprintf(output, font, xPos + xLocation + 6, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s", input);
        textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "%s", input);
        textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s", input); 
    }
    if(waitingforinput) {
        if(input[0] == '\0') {
            if(curflash < 45) {
                textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 8 - 3, makecol(32, 32, 32), "_");
                textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        } else {
            char addon = '\0';
            if(strlen(input) < (width / 8) - 1) {
                if(curflash < 45) {
                    addon = '_';
                } else {
                    addon = ' ';
                }
            }
            textprintf(output, font, xPos + xLocation + 6, yPos + yLocation + 8 - 2, makecol(32, 32, 32), "%s%c", input, addon);
            textprintf(output, font, xPos + xLocation + 5, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "%s%c", input, addon);
            textprintf(output, font, xPos + xLocation + 4, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "%s%c", input, addon); 
            if(addon != '_' && curflash < 45) {
                textprintf(output, font, xPos + xLocation + (strlen(input) - 1) * 8 + 5, yPos + yLocation + 8 - 3,  makecol(32, 32, 32), "_");
                textprintf(output, font, xPos + xLocation + (strlen(input) - 1) * 8 + 4, yPos + yLocation + 8 - 4, makecol(255, 255, 255), "_"); 
            }
        }
    };
}
